# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdapiobject import SDAPIObject
from .sdresource import SDResource
from .sdbasetypes import int2
from .sdapiobject import SDApiError
from .sdresource import EmbedMethod
from .apiexception import APIException

class SDResourceSVG(SDResource):
    """
    A vector graphics resource as it can be found in a SDPackage
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDResourceSVG
        """
        super(SDResourceSVG, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(parent : SDAPIObject, size : int2) -> SDResourceSVG:
        """
        Create a new SDResourceSVG under the specified parent

        :param parent: The parent data that will contains the newly created Resource. Can be SDPackage or SDResourceFolder
        :param size: The size of the image canvas in pixel
        """
        outResource = ctypes.c_void_p()
        _res = sd.getContext().SDResourceSVG_sNew(parent.mHandle, ctypes.byref(size), ctypes.byref(outResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outResource, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outResource.value, ownHandle=True)

    @staticmethod
    def sNewFromFile(parent : SDAPIObject, filePath : str, embedMethod : EmbedMethod) -> SDResourceSVG:
        """
        Create a new SDResourceSVG from the specified file. The resource may reference or copy the file content depending on the EmbedMethod

        :param parent: The parent data that will contains the newly created Resource. Can be SDPackage or SDResourceFolder
        :param filePath: The SVG file path
        :param embedMethod: The embed method
        """
        outResource = ctypes.c_void_p()
        _res = sd.getContext().SDResourceSVG_sNewFromFile(parent.mHandle, ctypes.create_string_buffer(filePath.encode('utf-8')), embedMethod.value, ctypes.byref(outResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outResource, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outResource.value, ownHandle=True)

